/*
 * Decompiled with CFR 0.152.
 */
package com.night.star.shopjei;

import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import com.mojang.blaze3d.platform.InputConstants;
import com.night.star.shopjei.ShopJeiEntry;
import com.night.star.shopjei.ShopJeiJEIPlugin;
import com.night.star.shopjei.utils.FtbQuestUtils;
import com.night.star.shopjei.utils.SdmShopUIUtils;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ShopJeiCategory
implements IRecipeCategory<ShopJeiEntry> {
    private final IDrawable background;
    private final IDrawable icon;
    public static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"shopjei", (String)"textures/gui/shopjei.png");
    private static final int LINK_MARGIN_BOTTOM = 2;
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final int LINK_HEIGHT;
    private static final MutableComponent BUY_BUTTON_TEXT;
    private static final MutableComponent SELL_BUTTON_TEXT;
    private static final MutableComponent LOCK_BUTTON_TEXT;
    private static final int BUY_BUTTON_WIDTH;
    private static final int SELL_BUTTON_WIDTH;
    private static final int LOCK_BUTTON_WIDTH;

    public ShopJeiCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_42516_));
        this.background = guiHelper.createDrawable(BACKGROUND_TEXTURE, 0, 0, 87, 25);
    }

    public RecipeType<ShopJeiEntry> getRecipeType() {
        return ShopJeiJEIPlugin.PROFESSION_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.shopjei.info");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight() + LINK_HEIGHT + 2;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ShopJeiEntry data, IFocusGroup focuses) {
        Item money = Objects.requireNonNullElse((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"lightmanscurrency", (String)"coin_copper")), Items.f_41852_);
        if (!data.isSell()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 7, 5).addItemStack(new ItemStack((ItemLike)money, (int)data.getPrice()));
            builder.addSlot(RecipeIngredientRole.OUTPUT, 65, 5).addItemStack(new ItemStack((ItemLike)data.getItemStack().m_41720_(), (int)data.getCount()));
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, 7, 5).addItemStack(new ItemStack((ItemLike)data.getItemStack().m_41720_(), (int)data.getCount()));
            builder.addSlot(RecipeIngredientRole.OUTPUT, 65, 5).addItemStack(new ItemStack((ItemLike)money, (int)data.getPrice()));
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, final ShopJeiEntry data, IFocusGroup focuses) {
        builder.addInputHandler(new IJeiInputHandler(){

            public ScreenRectangle getArea() {
                if (data.isLock()) {
                    int linkX = (ShopJeiCategory.this.background.getWidth() - LOCK_BUTTON_WIDTH) / 2;
                    int linkY = ShopJeiCategory.this.background.getHeight();
                    return new ScreenRectangle(linkX, linkY, LOCK_BUTTON_WIDTH, LINK_HEIGHT);
                }
                if (data.isSell()) {
                    int linkX = (ShopJeiCategory.this.background.getWidth() - SELL_BUTTON_WIDTH) / 2;
                    int linkY = ShopJeiCategory.this.background.getHeight();
                    return new ScreenRectangle(linkX, linkY, SELL_BUTTON_WIDTH, LINK_HEIGHT);
                }
                int linkX = (ShopJeiCategory.this.background.getWidth() - BUY_BUTTON_WIDTH) / 2;
                int linkY = ShopJeiCategory.this.background.getHeight();
                return new ScreenRectangle(linkX, linkY, BUY_BUTTON_WIDTH, LINK_HEIGHT);
            }

            public boolean handleInput(double mouseX, double mouseY, IJeiUserInput input) {
                InputConstants.Key key = input.getKey();
                boolean isLeftClick = key.m_84868_() == InputConstants.Type.MOUSE && key.m_84873_() == 0 && !input.isSimulate();
                Minecraft minecraft = Minecraft.m_91087_();
                if (isLeftClick) {
                    minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                    if (data.isLock()) {
                        FtbQuestUtils.OpenGui(data.getQuest());
                    } else {
                        SdmShopUIUtils.openBuyGui(data.getShopTab(), data.getEntry());
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void draw(ShopJeiEntry data, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        boolean isMouseOverLink;
        int linkY;
        int linkX;
        MutableComponent linkComponent;
        this.background.draw(guiGraphics, 0, 0);
        Minecraft minecraft = Minecraft.m_91087_();
        if (data.isLock()) {
            linkComponent = LOCK_BUTTON_TEXT;
            linkX = (this.background.getWidth() - LOCK_BUTTON_WIDTH) / 2;
            linkY = this.background.getHeight();
            isMouseOverLink = this.isMouseOverLink(mouseX, mouseY, SELL_BUTTON_WIDTH);
        } else if (data.isSell()) {
            linkComponent = SELL_BUTTON_TEXT;
            linkX = (this.background.getWidth() - SELL_BUTTON_WIDTH) / 2;
            linkY = this.background.getHeight();
            isMouseOverLink = this.isMouseOverLink(mouseX, mouseY, SELL_BUTTON_WIDTH);
        } else {
            linkComponent = BUY_BUTTON_TEXT;
            linkX = (this.background.getWidth() - BUY_BUTTON_WIDTH) / 2;
            linkY = this.background.getHeight();
            isMouseOverLink = this.isMouseOverLink(mouseX, mouseY, BUY_BUTTON_WIDTH);
        }
        linkComponent = linkComponent.m_130938_(style -> style.m_131162_(Boolean.valueOf(true)));
        int linkColor = isMouseOverLink ? -5383962 : -13408564;
        guiGraphics.m_280614_(minecraft.f_91062_, (Component)linkComponent, linkX, linkY, linkColor, false);
    }

    public boolean isMouseOverLink(double mouseX, double mouseY, int width) {
        int linkX = (this.background.getWidth() - width) / 2;
        int linkY = this.background.getHeight();
        return mouseX >= (double)linkX && mouseX < (double)(linkX + width) && mouseY >= (double)linkY && mouseY < (double)(linkY + LINK_HEIGHT);
    }

    public void getTooltip(ITooltipBuilder tooltip, ShopJeiEntry data, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        boolean isMouseOverLink = data.isSell() ? this.isMouseOverLink(mouseX, mouseY, SELL_BUTTON_WIDTH) : this.isMouseOverLink(mouseX, mouseY, BUY_BUTTON_WIDTH);
        if (isMouseOverLink) {
            if (data.isLock()) {
                tooltip.add((FormattedText)Component.m_237115_((String)"gui.shopjei.lock_info").m_130940_(ChatFormatting.YELLOW));
                tooltip.add((FormattedText)Component.m_237110_((String)"gui.shopjei.click_lock", (Object[])new Object[]{data.getQuestTitle()}).m_130940_(ChatFormatting.GRAY));
                return;
            }
            if (!data.isSell()) {
                tooltip.add((FormattedText)Component.m_237115_((String)"gui.shopjei.click_buy").m_130940_(ChatFormatting.YELLOW));
                tooltip.add((FormattedText)Component.m_237110_((String)"gui.shopjei.show_money", (Object[])new Object[]{data.getPrice()}).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((FormattedText)Component.m_237115_((String)"gui.shopjei.click_sell").m_130940_(ChatFormatting.YELLOW));
                tooltip.add((FormattedText)Component.m_237110_((String)"gui.shopjei.show_money", (Object[])new Object[]{data.getPrice()}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    static {
        Objects.requireNonNull(ShopJeiCategory.mc.f_91062_);
        LINK_HEIGHT = 9;
        BUY_BUTTON_TEXT = Component.m_237115_((String)"gui.shopjei.buy");
        SELL_BUTTON_TEXT = Component.m_237115_((String)"gui.shopjei.sell");
        LOCK_BUTTON_TEXT = Component.m_237115_((String)"gui.shopjei.lock");
        BUY_BUTTON_WIDTH = ShopJeiCategory.mc.f_91062_.m_92852_((FormattedText)BUY_BUTTON_TEXT);
        SELL_BUTTON_WIDTH = ShopJeiCategory.mc.f_91062_.m_92852_((FormattedText)SELL_BUTTON_TEXT);
        LOCK_BUTTON_WIDTH = ShopJeiCategory.mc.f_91062_.m_92852_((FormattedText)LOCK_BUTTON_TEXT);
    }
}

